from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math

class BoxArena(Arenas.SuperArena):
    "DSL Official Tournament Arena."
    name = "DSL Tournament Arena"
    preview = "DSLTourney/DSLTourney_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-13.87, 12.28, 16.45, -16.43)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLTourney/DSLTourney.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        fmod = 0.015
        degrad = 0.01745
        self.AddStaticCamera("              Static-Over", (0, 29, 0), (91*degrad, 90*degrad), degrad*56)
        self.AddStaticCamera("              Static-1", (10, 18, -17), (55*degrad, 321*degrad), degrad*70)
        self.AddStaticCamera("              Static-2", (00, 18, -18), (55*degrad, 0), degrad*77)

        self.AddWatchCamera("               WatchCam-1", (-20, 15, 18), (12, 20, 50*degrad, 30*degrad))
        self.AddWatchCamera("               WatchCam-2", (15, 20, 15), (14, 22, 50*degrad, 30*degrad))
        self.AddWatchCamera("               WatchCam-3", (20, 15, -18), (12, 20, 50*degrad, 30*degrad))
        self.AddWatchCamera("               WatchCam-4", (-15, 20, -15), (16, 24, 50*degrad, 40*degrad))
        
        self.players = ()
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.051,1.83754), (-12.4182,0.051,12.4283), (-12.4182,0.051,1.83754))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-8.17686,0.051,12.4283), (-12.4182,0.051,12.4283))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-12.4182,0.051,12.4283), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.25999,0.051,12.4283), (-2.49123,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (2.25999,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((12.413,0.051,12.4283), (7.93297,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,1.91641), (12.413,0.051,12.4283))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (12.413,0.051,-12.4279), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (12.413,0.051,-12.4279), (12.413,0.051,-1.93329))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (8.17711,0.051,-12.4279), (12.413,0.051,-12.4279))
        self.AddShadowTriangle((-2.26871,0.051,-12.4279), (2.49519,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (-2.26871,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-12.4182,0.051,-12.4279), (-7.93688,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-1.8361), (-12.4182,0.051,-12.4279))
        self.AddShadowTriangle((-2.49123,0.051,9.91855), (-8.17686,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.49519,0.051,-9.92447), (8.17711,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (-10.2877,0.051,-1.8361), (-2.26871,0.051,-9.92447))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (7.93297,0.051,9.91855), (2.25999,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (-2.49123,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (2.25999,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (10.2878,0.051,1.91641), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (10.2878,0.051,-1.93329), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (2.49519,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-7.93688,0.051,-9.92447), (-2.26871,0.051,-9.92447))
        
    def HazardsOn(self, on):
        if on:
            self.SetSubMaterialSound("saws", "metal", 8.0, "Sounds\\sawblade_hits_loop.wav")
            self.SetSubMaterialSound("spikes_collision", "metal", 8.0, "Sounds\\hzd_spike_hit2.wav")
        #Walls
        self.AddCollisionLine((-13.87, -16.43), (-13.87, 16.45))
        self.AddCollisionLine((-13.87, 16.45), (12.28, 16.45))
        self.AddCollisionLine((12.28, 16.45), (12.28, -16.43))
        self.AddCollisionLine((12.28, -16.43), (-13.87, -16.43))

        # Dunno what these were for.  Maybe because the collision lines used to be messy?
        # self.AddPOV(0, (0, 0), (1, 2, 3, 4))
        # self.AddPOV(1, (-0.2, -14.4), (0,))
        # self.AddPOV(2, (0.2, -14.4), (0,))
        # self.AddPOV(3, (-0.2, 14.2), (0,))
        # self.AddPOV(4, (0.2, 14.2), (0,))

        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)

    def Tick(self):
        
        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -3:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BoxArena)
